#!/usr/bin/env python
#!/usr/local/bin/python
#
# Version 1.0
#
# Copyright (C) 2006  Ulrich Langenbach
#
# for any question, improvements and comments send an email to
#
# ulrich@falaba.de
#
# with 'dirs.py' as subject
# 
# This program is free software; you can redistribute it and/or modify 
# it under the terms of the GNU General Public License as published by 
# the Free Software Foundation; either version 2 of the License, or 
# (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import os

def printHelp():
		print ""
		print "optional arguments:"
		print ""
		print "-max-depth             specifies the maximum recursive depth"
		print ""
		print "-comments              with this argument the script looks in .comment files"
		print "                       in every directory and the first line of this file is"
		print "                       as an comment of the directory the file lies in"
		print ""
		print "-excl-dirs list        the directories specified with this comma seperated list"
		print "                       will be excluded on every level of the recursive search"
		print ""
		print "-help                  prints this (hopefully) helping lines"
		print ""
		print "example: ./dirs.py -max-depth=2 -excl-dirs=proc -comments=commentFile /path"
		print ""
		print "prints the file structure for the dirtree package in tex format"
		print ""
		print "for the tex dirtree package look at "
		print "http://tug.ctan.org/cgi-bin/ctanPackageInformation.py?id=dirtree"
		print ""

def isInt(str):
    try:int(str)
    except ValueError:return False
    else:return True

def parseDir(root,directory,deepness,maxDepth,skipDirs,comments):
    deepness=deepness+1
    dirs = os.listdir(directory)
    dirs.sort()
    for curr in dirs:
        do = True

        for currDir in skipDirs:
            if currDir in curr:
                do = False

        commentFilePath = directory + curr + commentFile

        if (comments == True) and os.path.isfile(commentFilePath):
            file = open(commentFile,'r')
            datInhalt = file.readline()
            file.close()
            datInhalt=datInhalt.strip()
            comment = "\\DTcomment{%(datInhalt)s}" % vars()
        else:
            comment = ""

        nextDir = directory + curr + "/"
        #print nextDir
        if os.path.isdir(nextDir) and do:
            printDirectory = curr.replace("_","\_")
            print ".%(deepness)u %(printDirectory)s %(comment)s." % vars()
            if (maxDepth > deepness):
                parseDir(root,nextDir,deepness,maxDepth,skipDirs,comments)

# parsing arguments

if (len(sys.argv) > 1):
  if (sys.argv[1] != ""):
    if (sys.argv[1] == "help") or (sys.argv[1] == "--help"):
	      printHelp()
    else:
        maxDepth = 100000
        skipDirs = []
        commentFile = ""
        comments = False
        directory = "./"
        for i in sys.argv:
            if (i.find("=") > 0):
                i = i.split("=")
                if (i[0] == "-excl-dirs"):
                    if i[1].find(","):
                        skipDirs = i[1].split(",")
                    else:
                        skipDirs.append(i[1])
                elif (i[0] == "-max-depth"):
                    maxDepth = long(i[1])
                elif (i[0] == "-comments"):
                    comments = True
                    commentFile = i[1]
            elif (i == "-comments"):
                comments = True
                commentFile = ".comment"
            else:
                directory = i

# parsing directories

        print "\\dirtree{%"
    
        top = directory.split("/")
        if (top[len(top)-1] == ""):
            top = top[len(top)-1]
        else:
            top = top[len(top)-2]
        if (top == ".") or (top == "..") or (top==""):
            top = "/"
            print ".1 %(top)s." % vars()
            
            parseDir(directory,directory,1,maxDepth,skipDirs,comments)
                    
            print "}"

  else:
      printHelp()
else:
    printHelp()
    